import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';
export 'package:google_fonts/google_fonts.dart';

class Style {
  Style._();

  /// ###################### Colors ##########################
  static const white = Color(0xFFFFFFFF);
  static const transparent = Colors.transparent;
  static const blue = Color(0xFF0963E0);
  static const blueColor = Color(0xff3a92f5);
  static const primary = Color(0xFFBB9B6A);
  static const green = Color(0xFF16AA16);
  static const greenColor = Color(0xFF60CC3B);
  static const red = Color(0xFFFF3D00);
  static const redColor = Color(0xFFF34750);
  static const starColor = Color(0xffFFA826);
  static const bg = Color(0xFFF9F9FA);
  static const background = Color(0xFFF9F9FA);
  static const greyColor = Color(0xFFF4F5F8);
  static const deepPurple = Color(0xFF673AB7);
  static const revenueColor = Color(0xFFFF8A00);
  static const colorGrey = Color.fromRGBO(179, 181, 193, 1);
  static const iconsColor = Color(0xFF232B2F);
  static const textColor = Color(0xFF88887D);
  static const bottomNavigationBarColor = Color(0xFF191919);
  static const black12 = Color(0x1F000000);
  static const bottomSheetIconColor = Color(0xFFC4C5C7);
  static const iconColor = Color(0xFFC4C4C4);
  static const shimmerBase = Color(0xFFE0E0E0);
  static const shimmerHighlight = Color(0xFFF5F5F5);
  static const tabBarBorderColor = Color(0xFFDEDFE1);
  static const toggleColor = Color(0xFFE7E7E7);
  static const toggleShadowColor = Color(0xFF6B6B6B);
  static const logOutBgColor = Color(0xFFB9B9B9);
  static const borderColor = Color(0xFFF2F2F2);
  static const addCountColor = Color(0xFFF7F7F7);
  static const discountColor = Color(0xFFF3F3F3);
  static const pending = Color(0xFFFFD989);
  static const pendingDark = Color(0xFFF19204);
  static const black = Color(0xFF000000);
  static const blackBanner = Color(0xff1A1D2E);
  static const purple = Color(0xffC26BF9);
  static const pink = Color(0xffFF38AB);
  static const yellow = Color(0xffFFB800);
  static const whiteWithOpacity = Color(0x30ffffff);
  static const success = Color(0xff31D0AA);
  static const icon = Color(0x30B1B1B1);
  static const textHint = Color(0xff939393);
  static const bgDark = Color(0xff18191D);
  static const socialButtonDark = Color(0xff33393F);
  static const socialButtonLight = Color(0x40ffffff);
  static const bottomBarColorDark = Color(0xff444444);
  static const bottomBarColorLight = Color(0xff000000);
  static const categoryDark = Color(0xff33393F);
  static const dividerColor = Color(0xffF3F3F3);
  static const seeAllColor = Color(0xff289AB3);
  static const subCategory = Color(0xffF6F6F6);
  static const unselectLayout = Color(0xffAEAEAE);
  static const unselectTabBar = Color(0xffA0A09C);
  static const tabBarBg = Color(0xffF4F4F4);
  static const shadow = Color(0xC9DFE2EA);
  static const differBorderColor = Color(0xFFE0E0E0);
  static const mainBack = Color(0xFFF4F4F4);
  static const dragElement = Color(0xFFC4C5C7);
  static const semiGrey = Color(0xFFF1F1F1);
  static const unselect = Color(0xFFF8F8F8);
  static const backgroundColor = Color(0xFFF8F8F8);
  static const orange = Color(0xffF26110);
  static const Color defaultBorderColor = Color(0xffdddddd);
  static const Color defaultLiveTimeIndicatorColor = Color(0xff444444);

  static const Color editProfileCircle = Color(0xFFF4F5F8);
  static const Color dontHaveAccBtnBack = Color(0xFFF8F8F8);
  static const Color outlineButtonBorder = Color(0xFFD2D2D7);
  static const Color unselectedBottomItem = Color(0xFFA1A1A1);
  static const Color hint = Color(0xFFBABABA);
  static const Color unselectedTab = Color(0xFF929292);
  static const Color newStoreDataBorder = Color(0xDCDCDCC9);
  static const Color addProductSearchedToBasket = Color.fromRGBO(0, 0, 0, 0.62);
  static const Color rate = Color(0xFFFFB800);
  static const Color divider = Color.fromRGBO(0, 0, 0, 0.04);
  static const Color reviewText = Color(0xFF88887E);
  static const Color bannerGradient1 = Color.fromRGBO(0, 0, 0, 0.5);
  static const Color bannerGradient2 = Color.fromRGBO(0, 0, 0, 0);
  static const Color brandTitleDivider = Color(0xFF999999);
  static const Color discountProduct = Color(0xFFD21234);
  static const Color notificationTime = Color(0xFF8B8B8B);
  static const Color separatorDot = Color(0xFFD9D9D9);
  static const Color arrowRight = Color(0xFFD9D9D9);
  static const Color locationAddress = Color(0xFF343434);
  static const Color selectedItemsText = Color(0xFFA0A09C);
  static const Color iconButtonBack = Color(0xFFE9E9E6);
  static const Color addButtonColor = Color(0xFFF3F3F3);
  static const Color removeButtonColor = Color(0xFFF7F7F7);
  static const Color shadowCart = Color.fromRGBO(194, 194, 194, 0.65);
  static const Color extrasInCart = Color(0xFF9EA3A8);
  static const Color notDoneOrderStatus = Color(0xFFF5F6F6);
  static const Color unselectedBottomBarBack = Color(0xFFEFEFEF);
  static const Color unselectedBottomBarItem = Color(0xFFB9B9B9);
  static const Color bottomNavigationShadow =
      Color.fromRGBO(207, 207, 207, 0.65);
  static const Color profileModalBack = Color(0xFFF5F5F5);
  static const Color arrowRightProfileButton = Color(0xFFCCCCCC);
  static const Color customMarkerShadow = Color.fromRGBO(117, 117, 117, 0.29);
  static const Color selectedTextFromModal = Color(0xFF202020);
  static const Color verticalDivider = Color(0xFFDDDDDA);
  static const Color unselectedOrderStatus = Color(0xFFE9E9E9);
  static const Color borderRadio = Color(0xFFB8B8B8);
  static const Color shippingType = Color(0xFF95999D);
  static const Color attachmentBorder = Color(0xFFDCDCDC);
  static const Color orderStatusProgressBack = Color(0xFFE7E7E7);
  static const Color searchHint = Color(0xFF2E3456);
  static const Color inStockText = Color(0xFF16AA16);
  static const Color discountText = Color(0xFFC0C2CC);
  static const Color shadowSecond = Color(0x45A8A8A9);
  static const Color invoiceColor = Color(0xff232B2F);

  /// dark theme based colors
  static const Color mainBackDark = Color(0xFF1E272E);
  static const Color dontHaveAnAccBackDark = Color(0xFF2B343B);
  static const Color dragElementDark = Color(0xFFE5E5E5);
  static const Color shimmerBaseDark = Color.fromRGBO(117, 117, 117, 0.29);
  static const Color shimmerHighlightDark = Color.fromRGBO(194, 194, 194, 0.65);
  static const Color borderDark = Color(0xFF494B4D);
  static const Color partnerChatBack = Color(0xFF1A222C);
  static const Color yourChatBack = Color(0xFF25303F);

  static const walletGradient = LinearGradient(
      begin: Alignment.topLeft,
      end: Alignment.bottomRight,
      colors: [
        Color(0xffFFB300),
        Color(0xffFEB101),
        Color(0xffFF38AB),
        Color(0xffFE0000),
      ]);

  static List<BoxShadow> walletShadow = [
    BoxShadow(
      color: pink.withOpacity(0.4),
      offset: const Offset(0.6, 4),
      blurRadius: 10,
      spreadRadius: 0.1,
    ), //BoxShadow
  ];
  static List<BoxShadow> primaryShadow = [
    BoxShadow(
      color: primary.withOpacity(0.6),
      blurRadius: 30,
      offset: const Offset(0, 6),
      spreadRadius: 0,
    )
  ];
  static List<BoxShadow> greyShadow = [
    BoxShadow(
      color: colorGrey.withOpacity(0.6),
      blurRadius: 30,
      offset: const Offset(0, 6),
      spreadRadius: 0,
    )
  ];

  static const MaterialColor primaryMaterialColor =
      MaterialColor(0xFF9581FF, <int, Color>{
    50: Color(0xFFEFECFF),
    100: Color(0xFFD7D0FF),
    200: Color(0xFFBDB0FF),
    300: Color(0xFFA390FF),
    400: Color(0xFF8F79FF),
    500: Color(0xFF7B61FF),
    600: Color(0xFF7359FF),
    700: Color(0xFF684FFF),
    800: Color(0xFF5E45FF),
    900: Color(0xFF6C56DD),
  });

  /// ------------------ Fonts ---------------- ///

  static TextStyle gloryNormal({
    double size = 16,
    Color color = Style.black,
    double letterSpacing = 0,
    TextDecoration textDecoration = TextDecoration.none,
    FontStyle? fontStyle,
  }) =>
      GoogleFonts.glory(
        fontSize: size,
        fontWeight: FontWeight.w500,
        color: color,
        letterSpacing: letterSpacing,
        decoration: textDecoration,
        fontStyle: fontStyle,
      );

  /// ------------------------------------------- ///
  static TextStyle interBold({
    double size = 18,
    Color color = Style.black,
    double letterSpacing = 0,
  }) =>
      GoogleFonts.inter(
        fontSize: size,
        fontWeight: FontWeight.bold,
        color: color,
        decoration: TextDecoration.none,
        letterSpacing: letterSpacing,
      );

  static TextStyle interSemi({
    double size = 18,
    Color color = Style.black,
    TextDecoration decoration = TextDecoration.none,
    double letterSpacing = 0,
    FontStyle? fontStyle,
  }) =>
      GoogleFonts.inter(
        fontSize: size,
        fontWeight: FontWeight.w700,
        color: color,
        letterSpacing: letterSpacing,
        decoration: decoration,
        fontStyle: fontStyle,
      );

  static TextStyle interMedium({
    double size = 16,
    Color color = Style.black,
    TextDecoration decoration = TextDecoration.none,
    double letterSpacing = 0,
    FontStyle? fontStyle,
  }) =>
      GoogleFonts.inter(
        fontSize: size,
        fontWeight: FontWeight.w600,
        color: color,
        letterSpacing: letterSpacing,
        decoration: decoration,
        fontStyle: fontStyle,
      );

  static TextStyle interNormal({
    double size = 16,
    Color color = Style.black,
    double letterSpacing = 0,
    TextDecoration textDecoration = TextDecoration.none,
    FontStyle? fontStyle,
  }) =>
      GoogleFonts.inter(
        fontSize: size,
        fontWeight: FontWeight.w500,
        color: color,
        letterSpacing: letterSpacing,
        decoration: textDecoration,
        fontStyle: fontStyle,
      );

  static TextStyle interRegular({
    double size = 16,
    Color color = Style.black,
    double letterSpacing = 0,
    TextDecoration textDecoration = TextDecoration.none,
    FontStyle? fontStyle,
  }) =>
      GoogleFonts.inter(
        fontSize: size,
        fontWeight: FontWeight.w400,
        color: color,
        letterSpacing: letterSpacing,
        decoration: textDecoration,
        fontStyle: fontStyle,
      );
}
